# 画面設計書 15-OPFS 並行性テスト

## 概要

本ドキュメントは、SQLite WASMプロジェクトにおけるOPFS 並行性テスト画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は、複数のWorkerスレッドを使用してOPFS（Origin Private File System）VFSの並行アクセス性能と整合性をテストするためのページである。

**業務上の目的・背景**：OPFSにおける並行処理は現在のブラウザ実装において課題が多い（pain point）。本画面は、複数のWorkerが同一データベースに同時アクセスする際の動作を検証し、排他制御や「unlock ASAP」モードの効果を評価するために使用される。開発者はこのテストを通じて、マルチスレッド環境でのOPFS VFSの限界と特性を把握できる。

**画面へのアクセス方法**：インデックスページ（index.html）の「OPFS Concurrency」リンクからアクセスするか、直接 `tests/opfs/concurrency/index.html` にアクセスする。

**主要な操作・処理内容**：
1. ページ読み込み時にURLパラメータから設定を取得（workers, interval, iterations等）
2. 指定数のWorkerスレッドを起動
3. すべてのWorkerがロード完了後、同時にテスト実行を開始
4. 各Workerがinterval間隔でiterations回のDB操作を実行
5. 結果を画面に表示し、成功/失敗数をカウント

**画面遷移**：
- 遷移元: WASM テストページインデックス（index.html）
- ページ内リンク: 異なるパラメータ設定でのテスト実行リンク

**権限による表示制御**：特になし（開発者向けテストページ）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | SQLiteライブラリ初期化 | 主機能 | 複数Worker用sqlite3モジュール初期化 |
| 43 | OS抽象化層（VFS） | 主機能 | OPFS VFSの並行アクセステスト |
| 42 | ミューテックス | 主機能 | 複数Worker間の排他制御テスト |

## 画面種別

テスト実行・結果表示画面

## URL/ルーティング

```
/ext/wasm/tests/opfs/concurrency/index.html
```

URLパラメータ:
- `workers=N`: Workerの数（デフォルト: 3）
- `interval=N`: 各ワークロード間のインターバル（ミリ秒、デフォルト: 1000）
- `iterations=N`: 各Workerのイテレーション回数（デフォルト: 10）
- `verbose=1-3`: OPFS VFSの詳細ログレベル（デフォルト: 1）
- `unlock-asap=0-1`: "unlock ASAP"モードの有効/無効（デフォルト: 0）
- `no-unlink`: DB削除を無効化

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| workers | 入力 | number | 任意 | 起動するWorker数 |
| interval | 入力 | number | 任意 | ワークロード間隔（ms） |
| iterations | 入力 | number | 任意 | イテレーション回数 |
| verbose | 入力 | number | 任意 | 詳細ログレベル(1-3) |
| unlock-asap | 入力 | number | 任意 | unlock ASAPモード(0/1) |
| cb-log-reverse | 入力 | checkbox | 任意 | ログ順序逆転 |
| テスト結果 | 出力 | text/HTML | - | 各Workerの実行ログと結果 |

## 表示項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| タイトル（h1） | "sqlite3 OPFS Worker concurrency tester" | 常時表示 |
| 説明文 | OPFSの並行処理が課題である旨の免責事項 | 常時表示 |
| URLフラグ説明 | 各パラメータの使い方 | 常時表示 |
| 警告文 | WasmMemory割り当て失敗時の対処法 | 常時表示 |
| テストリンク | 異なるパラメータ設定のリンク | 常時表示 |
| ログ逆順チェックボックス | "Reverse log order?" | 常時表示 |
| テスト出力エリア | 各Workerからのログ | テスト実行中・完了後 |

## イベント仕様

### 1-ページ読み込み

1. URLパラメータを解析してオプション設定
2. テストリンクを動的に生成
3. 指定数のWorkerを起動（worker.js）
4. 各Workerにonmessageハンドラを設定

### 2-Workerメッセージ受信

Worker→メインスレッドへのメッセージ:
- `type: 'loaded'`: Worker読み込み完了
- `type: 'stdout'`: 標準出力ログ
- `type: 'stderr'`: 標準エラーログ
- `type: 'error'`: エラー発生
- `type: 'finished'`: Worker正常終了
- `type: 'failed'`: Worker失敗

### 3-全Worker読み込み完了

すべてのWorkerが'loaded'を送信したら:
1. "All N workers loaded. Telling them to run..."と表示
2. workers.post('run')で全Workerにテスト開始を通知

### 4-テスト完了判定

全Workerがfinished/failedを送信したら:
- 失敗があれば: "Finished with N failure(s)." (tests-failクラス)
- すべて成功: "All N workers finished." (tests-passクラス)

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 並行テスト | テスト用テーブル | INSERT/SELECT/UPDATE | 各Workerからの並行DB操作 |

### テーブル別更新項目詳細

各Worker内で動的に作成・操作されるテーブル。詳細はworker.jsの実装に依存。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | "Launching N workers. Options: {options}" | 起動時 |
| MSG002 | 情報 | "Launching worker..." | 各Worker起動時 |
| MSG003 | 情報 | "Worker #N: loaded" | Worker読み込み完了時 |
| MSG004 | 情報 | "All N workers loaded. Telling them to run..." | 全Worker準備完了時 |
| MSG005 | 成功 | "All N workers finished." | 全Worker正常終了時 |
| MSG006 | エラー | "Finished with N failure(s)." | 失敗Worker存在時 |
| MSG007 | エラー | "Worker #N: ERROR: {message}" | Workerエラー発生時 |
| MSG008 | エラー | "Unhandled message type: {type}" | 未知メッセージ受信時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| WasmMemory割り当て失敗 | 開発者コンソールに警告、タブ再オープンを推奨 |
| Worker起動失敗 | エラーログ出力 |
| Worker内エラー | 'error'/'failed'メッセージで通知 |

## 備考

- OPFSの並行処理は現在のブラウザ実装で課題が多い
- "unlock ASAP"モードは高並行性・低速度のトレードオフ
- Chrome特有のWasmMemory問題でタブ再起動が必要な場合あり

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Worker間通信のメッセージ構造とオプション設定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | test.js | `ext/wasm/tests/opfs/concurrency/test.js` | optionsオブジェクトとworkersオブジェクト |

**読解のコツ**: options.*でURLパラメータから取得した設定を管理。workers配列はWorkerインスタンスを保持。

#### Step 2: エントリーポイントを理解する

HTMLファイルとメインスクリプトのロード。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `ext/wasm/tests/opfs/concurrency/index.html` | test.jsのロードとsqlite3.dirパラメータ |

**主要処理フロー**:
1. **行50**: test.jsをsqlite3.dir指定でロード

#### Step 3: テスト制御を理解する

メインスレッドでのWorker管理ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | test.js | `ext/wasm/tests/opfs/concurrency/test.js` | Worker生成と通信処理 |

**主要処理フロー**:
- **行53-72**: URLパラメータからオプション取得
- **行74-77**: workers.post関数で全Workerにメッセージ送信
- **行78-87**: checkFinished関数で完了判定
- **行88-114**: workers.onmessage関数でメッセージ処理
- **行141-160**: Worker生成とonmessage割り当て

### プログラム呼び出し階層図

```
index.html
    │
    └─ <script src="test.js">
           │
           ├─ URLパラメータ解析 → options
           │
           ├─ テストリンク動的生成
           │
           └─ for (0..workerCount)
                  │
                  └─ new Worker('worker.js?...')
                         │
                         ├─ postMessage({type:'loaded'})
                         │      ↓
                         │  [メイン] loaded カウント
                         │
                         ├─ [全員loaded] ← workers.post('run')
                         │
                         ├─ テスト実行
                         │      ├─ postMessage({type:'stdout'})
                         │      └─ ...
                         │
                         └─ postMessage({type:'finished'/'failed'})
                                ↓
                           [メイン] checkFinished()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ─────▶ test.js                      ─────▶ #test-output
(workers,interval,        │
 iterations,verbose,      ├─ Worker生成×N
 unlock-asap)             │
                          ▼
                    Worker #1 ──┐
                    Worker #2 ──┼─▶ OPFS DB並行アクセス
                    Worker #N ──┘
                          │
                          ▼
                    各Worker結果
                          │
                          ▼
                    checkFinished() → PASS/FAIL表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `ext/wasm/tests/opfs/concurrency/index.html` | テンプレート | メイン画面HTML |
| test.js | `ext/wasm/tests/opfs/concurrency/test.js` | ソース | Worker管理・結果表示 |
| worker.js | `ext/wasm/tests/opfs/concurrency/worker.js` | ソース | 個別Workerのテスト実行 |
| testing.css | `ext/wasm/common/testing.css` | スタイル | テストページ用スタイル |
